// ------------------------------------
//       OnBoardC STDIO Library
//            Version 2.0
//    by: Harry Konstas May.19/2000
// ------------------------------------
 
#include "OBL.h"


STDOUT *OpenStdout(int x, int y, int w, int h)
{
  int wdt;
  STDOUT *pOut;

  pOut=MemPtrNew(sizeof(STDOUT));

  pOut->x=x;
  pOut->y=y;
  pOut->w=w;
  pOut->h=h;
  pOut->history[0]=0;

  pOut->hgt=FntCharHeight();
  pOut->wdt=FntCharWidth(65);

  pOut->colstart=x/pOut->wdt;
  pOut->rowstart=y/pOut->hgt;

  pOut->colend=pOut->colstart+(w/pOut->wdt);
  pOut->rowend=pOut->rowstart+(h/pOut->hgt);

  pOut->curcol=pOut->colstart;
  pOut->currow=pOut->rowstart;

  pOut->sRec=MemPtrNew(sizeof(RectangleType));
  pOut->dRec=MemPtrNew(sizeof(RectangleType));
  pOut->cRec=MemPtrNew(sizeof(RectangleType));
  pOut->eRec=MemPtrNew(sizeof(RectangleType));

  RctSetRectangle(pOut->sRec,x,y,w,h+1);
  RctSetRectangle(pOut->dRec,x,y,w,h);
  RctSetRectangle(pOut->cRec,x,y+h-pOut->hgt,w,pOut->hgt);
  RctSetRectangle(pOut->eRec,x,y+h-pOut->hgt+1,w,pOut->hgt);

  WinEraseRectangle(pOut->sRec,0);
  WinSetClip(pOut->sRec);

  return pOut;

}

void WriteStdout(STDOUT *pOut, CharPtr string)
{

  int l;

  l=StrLen(string);
  if(!l) return;

  if(string[l-2]==10||string[l-2]==13) {
    WinScrollRectangle(pOut->sRec,up,pOut->hgt,pOut->dRec);
    string[l-2]=0;
  }
  else
  if(string[l-1]==10||string[l-1]==13) {
    WinScrollRectangle(pOut->sRec,up,pOut->hgt,pOut->dRec);
    string[l-1]=0;
  }

  WinEraseRectangle(pOut->cRec,0);
  WinDrawChars(string,StrLen(string),pOut->x,pOut->y+pOut->h-pOut->hgt);     

}

void ClearStdout(STDOUT *pOut)
{

  WinEraseRectangle(pOut->sRec,0);
  pOut->curcol=pOut->colstart;
  pOut->currow=pOut->rowstart;

}

void PrintStdout(STDOUT *pOut, char *s)
{

  char b[4];
  int i=0,x,y;

  b[1]=0;

  while(s[i]) {

    if(s[i]==13) {
      pOut->curcol=pOut->colstart;
      i++;continue;
    }

    if(s[i]==10) {
      pOut->curcol=pOut->colstart;
      pOut->currow++;
      if(pOut->currow>pOut->rowend) {
        pOut->currow=pOut->rowend;
        WinScrollRectangle(pOut->sRec,up,pOut->hgt,pOut->dRec);
        WinEraseRectangle(pOut->eRec,0);
      }
      i++;continue;
    }

    if(pOut->curcol==pOut->colend) {
      pOut->curcol=pOut->colstart;
      pOut->currow++;
    }

    if(pOut->currow>pOut->rowend) {
      pOut->currow=pOut->rowend;
      WinScrollRectangle(pOut->sRec,up,pOut->hgt,pOut->dRec);
      WinEraseRectangle(pOut->eRec,0);
    }

    x=pOut->curcol*pOut->wdt;
    y=pOut->currow*pOut->hgt;
    b[0]=s[i];
    WinDrawChars(b,1,x,y);
    pOut->curcol++; i++;

  }

}

char PutStdout(STDOUT *pOut, char c)
{
  char s[4];

  s[0]=c; s[1]=0;
  PrintStdout(pOut,s);
  return c;

}

char *GetStdin(STDOUT *pOut,char *buffer)
{

  Boolean t;
  EventType evt;
  EventPtr evtP;
  char s[82];

  int k,x,y,sx,cx,cy,kcount=0;

  evtP = &evt;
  buffer[0]=0; s[0]=0;

  cx=pOut->curcol*pOut->wdt;
  cy=pOut->currow*pOut->hgt;
  sx=cx;

  InsPtSetLocation(cx,cy);
  InsPtSetHeight(pOut->hgt);
  InsPtEnable(1);

  while(1) {
    EvtGetEvent(&evt,evtWaitForever);
    SysHandleEvent(&evt);

    k=evtP->data.keyDown.chr;

    if(evtP->eType==keyDownEvent) {
      if(kcount==80) {
        k=8;
        SndPlaySystemSound(1);
      }

      if(k==7) {
        SndPlaySystemSound(1);
        continue;
      }

      if(k==264||(k>515&&k<520)) {
        buffer[0]=-1; buffer[1]=0;
        return buffer;
      }

      if(k==10) {
        InsPtEnable(0);
        PrintStdout(pOut,"\n");
        break;
      }

      if(k==11) {
        StrCopy(s,pOut->history);
        kcount=StrLen(s);
        PrintStdout(pOut,pOut->history);
        cx=pOut->curcol*pOut->wdt;
        cy=pOut->currow*pOut->hgt;
        InsPtSetLocation(cx,cy);
      }

      // backspace
      if(k==8&&kcount&&pOut->curcol>0) {
        s[kcount-1]=32;
        pOut->curcol--;
        PutStdout(pOut,32);
        pOut->curcol--;
        s[--kcount]=0;
        cx=pOut->curcol*pOut->wdt;
        cy=pOut->currow*pOut->hgt;
        InsPtSetLocation(cx,cy);
      }

      if(k<32||k>127) continue;
      if(k>31) s[kcount++]=k; 

      s[kcount]=0;
      InsPtEnable(0);
      PutStdout(pOut,k);
      cx=pOut->curcol*pOut->wdt;
      cy=pOut->currow*pOut->hgt;
      InsPtSetLocation(cx,cy);
      InsPtEnable(1);
    }
  }

  StrCopy(buffer,s);
  StrCopy(pOut->history,s);
  return buffer;

}

int GetStdKey(void)
{

  EventType evt;
  EventPtr evtP;

  evtP = &evt;

  while(1) {
    EvtGetEvent(&evt,evtWaitForever);
    SysHandleEvent(&evt);
    if(evtP->eType==keyDownEvent) 
      return evtP->data.keyDown.chr;
  }

}

void CloseStdout(STDOUT *pOut)
{

  if(!pOut->sRec) return;
  WinEraseRectangle(pOut->sRec,0);
  RctSetRectangle(pOut->sRec,0,0,160,160);
  WinSetClip(pOut->sRec);

  MemPtrFree(pOut->sRec); 
  MemPtrFree(pOut->dRec); 
  MemPtrFree(pOut->cRec); 
  MemPtrFree(pOut->eRec); 
  MemPtrFree(pOut); 

}
 
